<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Lokerpro
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$length = get_theme_mod( 'pjs_excerpt_number', '20' );

$classes = array(
	'pjs-box-content',
	'pjs-archivepage',
	'pjs-smallthumb',
	'item-infinite',
	'clearfix',
);

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $classes ); ?>>
	<div class="pjs-list-table">
		<div class="pjs-table-row">
			<?php
			// Add thumnail.
			$featured_image_url = wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) );
			if ( ! empty( $featured_image_url ) ) :
				echo '<div class="content-thumbnail pjs-table-cell">';
					echo '<a href="' . esc_url( get_permalink() ) . '" itemprop="url" title="' . the_title_attribute(
						array(
							'before' => '',
							'after'  => '',
							'echo'   => false,
						)
					) . '" rel="bookmark">';
	//						the_post_thumbnail( 'thumbnail' );
			                the_post_thumbnail(  );
					echo '</a>';
				echo '</div>';
			endif;
			?>

			<header class="pjs-table-cell">
				<?php if ( ! empty( $featured_image_url ) ) { ?>
				<div class="header-title">
				<?php } else { ?>
				<div class="header-title-no-image">
				<?php } ?>	
					<h2 class="post-title" <?php echo lokerpro_itemprop_schema( 'headline' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>
						<a href="<?php the_permalink(); ?>" <?php echo lokerpro_itemprop_schema( 'url' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?> title="<?php the_title_attribute(); ?>" rel="bookmark"><?php the_title(); ?></a>
					</h2>

				</div>
			</header><!-- .entry-header -->
		</div>
	</div>

	<?php
	if ( '0' !== $length ) :
		?>
		<div class="item-article">
			<div class="entry-content" <?php echo lokerpro_itemprop_schema( 'text' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>
				<?php the_excerpt(); ?>
			</div><!-- .entry-content -->
			<?php
			echo '<div class="wp-dark-mode-ignore">';
			if ( shortcode_exists( 'ratings' ) ) {
				echo '<div class="lokerpro-postratings-results">';
				echo do_shortcode( '[ratings id="' . $post->ID . '" results="true"]' );
				echo '</div>';
			} elseif ( shortcode_exists( 'ratemypost-result' ) ) {
				echo do_shortcode( '[ratemypost-result]' );
			}
			echo '</div>';
			?>
		</div><!-- .item-article -->

	<?php endif; ?>

	<?php if ( is_sticky() ) { ?>
		<kbd class="kbd-sticky"><?php esc_attr_e( 'Recommendation', 'lokerpro' ); ?></kbd>
	<?php } ?>

</article><!-- #post-## -->
