<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Lokerpro
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Disable thumbnail options via customizer.
$thumbnail = get_theme_mod( 'pjs_active-singlethumb', 0 );

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> <?php echo lokerpro_itemtype_schema( 'CreativeWork' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>

	<div class="pjs-box-content pjs-single">

		<?php
		if ( 0 === $thumbnail ) :
			if ( has_post_thumbnail() ) {
				?>
				<figure class="wp-caption alignnone text-center pjs-thumbnail-blog">
					<?php the_post_thumbnail(); ?>

					<?php
					$get_description = get_post( get_post_thumbnail_id() )->post_excerpt;
					if ( ! empty( $get_description ) ) :
						?>
						<figcaption class="wp-caption-text"><?php echo esc_html( $get_description ); ?></figcaption>
					<?php endif; ?>
				</figure>
				<?php
			}
		endif;
		?>

		<header class="entry-header clearfix">
			<div class="title-wrap-blog">
				<?php the_title( '<h1 class="entry-title" ' . lokerpro_itemprop_schema( 'headline' ) . '>', '</h1>' ); ?>
				<?php
					$opsi11 = get_theme_mod( 'pjs_active-postedon', 0 );
					$opsi12 = get_theme_mod( 'pjs_active-viewedby', 0 );
					
					pjs_posted_on(); 
					
					if ( 0 === $opsi11 && 0 === $opsi12 ) { echo esc_html__( ' | ', 'lokerpro' ); }
					if ( 0 === $opsi12 ) {
						echo '<span class="posted-on">' . esc_html__( 'Viewed by ', 'lokerpro' ); 
						do_action( 'lokerpro_view_number_format' );
						echo esc_html__( ' people', 'lokerpro' ) . '</span></div>';
					} else {
						echo '</div>';
					}
				?>
				<div class="pjs-button-download">
					<?php do_action( 'lokerpro_add_share_the_content' ); ?>
				</div>
			</div>
		</header><!-- .entry-header -->

		<div class="entry-content entry-content-single" <?php echo lokerpro_itemprop_schema( 'text' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>
			<?php
				the_content();
			?>

		</div><!-- .entry-content -->

	</div><!-- .pjs-box-content -->

	<?php do_action( 'lokerpro_core_author_box' ); ?>

</article><!-- #post-## -->
