<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Lokerpro
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'pjs_posted_on' ) ) :
	/**
	 * Prints HTML with meta information for the current post-date/time and author.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	function pjs_posted_on() {
		$time_string = '<time class="entry-date published updated" ' . lokerpro_itemprop_schema( 'dateModified' ) . ' datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date published" ' . lokerpro_itemprop_schema( 'datePublished' ) . ' datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
		}

		$time_string = sprintf(
			$time_string,
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( 'c' ) ),
			esc_html( get_the_modified_date() )
		);
		$posted_on = esc_html__( 'Posted on ', 'lokerpro' ) . $time_string;

		$posted_by = sprintf(
			/* translators: used between list items, there is a space after the comma */
			esc_html__( 'By %s', 'lokerpro' ),
			'<span class="entry-author vcard" ' . lokerpro_itemprop_schema( 'author' ) . ' ' . lokerpro_itemtype_schema( 'person' ) . '><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '" title="' . __( 'Permalink to: ', 'lokerpro' ) . esc_html( get_the_author() ) . '" ' . lokerpro_itemprop_schema( 'url' ) . '><span ' . lokerpro_itemprop_schema( 'name' ) . '>' . esc_html( get_the_author() ) . '</span></a></span>'
		);
		if ( is_single() ) {
			$opsi1 = get_theme_mod( 'pjs_active-postedby', 0 );
			$opsi11 = get_theme_mod( 'pjs_active-postedon', 0 );
			echo '<div class="entry-meta">';
			if ( 0 === $opsi1 ) {
			echo '<span class="byline"> ' . $posted_by . '</span>';
			}
			if ( 0 === $opsi11 ) {
			echo '<span class="posted-on">' . $posted_on . '</span>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			}
			if ( function_exists( 'the_views' ) ) {
				echo '<span class="pjs-view">';
					the_views();
				echo '</span>';
			}
//			echo '</div>';
		} else {
			echo '<div class="entry-meta"><span class="byline"> ' . $posted_by . '</span><span class="posted-on">' . $posted_on . '</span></div>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		}
	}
endif; // endif pjs_posted_on.

if ( ! function_exists( 'pjs_custom_excerpt_length' ) ) :
	/**
	 * Filter the except length to 20 characters.
	 *
	 * @since 1.0.0
	 *
	 * @param int $length Excerpt length.
	 * @return int (Maybe) modified excerpt length.
	 */
	function pjs_custom_excerpt_length( $length ) {
		$length = get_theme_mod( 'pjs_excerpt_number', '20' );
		// absint sanitize int non minus.
		return absint( $length );
	}
endif; // endif pjs_custom_excerpt_length.
add_filter( 'excerpt_length', 'pjs_custom_excerpt_length', 999 );

if ( ! function_exists( 'pjs_custom_readmore' ) ) :
	/**
	 * Filter the except length to 20 characters.
	 *
	 * @since 1.0.0
	 *
	 * @param string $more More.
	 * @return string read more.
	 */
	function pjs_custom_readmore( $more ) {
		$more = get_theme_mod( 'pjs_read_more' );
		if ( empty( $more ) ) {
			return '';
		} else {
			return ' <a class="read-more" href="' . get_permalink( get_the_ID() ) . '" title="' . get_the_title( get_the_ID() ) . '" ' . lokerpro_itemprop_schema( 'url' ) . '>' . esc_html( $more ) . '</a>';
		}
	}
endif; // endif pjs_custom_readmore.
add_filter( 'excerpt_more', 'pjs_custom_readmore' );

if ( ! function_exists( 'pjs_get_pagination' ) ) :
	/**
	 * Retrieve paginated link for archive post pages.
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	function pjs_get_pagination() {
		global $wp_rewrite;
		global $wp_query;
		return paginate_links(
			apply_filters(
				'pjs_get_pagination_args',
				array(
					'base'      => str_replace( '99999', '%#%', esc_url( get_pagenum_link( 99999 ) ) ),
					'format'    => $wp_rewrite->using_permalinks() ? 'page/%#%' : '?paged=%#%',
					'current'   => max( 1, get_query_var( 'paged' ) ),
					'total'     => $wp_query->max_num_pages,
					'prev_text' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24"><path d="M17.59 18L19 16.59L14.42 12L19 7.41L17.59 6l-6 6z" fill="currentColor"/><path d="M11 18l1.41-1.41L7.83 12l4.58-4.59L11 6l-6 6z" fill="currentColor"/></svg>',
					'next_text' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24"><path d="M6.41 6L5 7.41L9.58 12L5 16.59L6.41 18l6-6z" fill="currentColor"/><path d="M13 6l-1.41 1.41L16.17 12l-4.58 4.59L13 18l6-6z" fill="currentColor"/></svg>',
					'type'      => 'list',
				)
			)
		);
	}
endif; // endif pjs_get_pagination.

if ( ! function_exists( 'pjs_move_post_navigation' ) ) :
	/**
	 * Move post navigation in top after content.
	 *
	 * @param string $content Contents.
	 * @since 1.0.0
	 *
	 * @return string $content
	 */
	function pjs_move_post_navigation( $content ) {
		if ( is_singular() && in_the_loop() ) {
			$pagination = wp_link_pages(
				array(
					'before'      => '<div class="page-links"><span class="page-text">' . esc_html__( 'Pages:', 'lokerpro' ) . '</span>',
					'after'       => '</div>',
					'link_before' => '<span class="page-link-number">',
					'link_after'  => '</span>',
					'echo'        => 0,
				)
			);
			$content   .= $pagination;
			return $content;
		}
		return $content;
	}
endif; // endif pjs_move_post_navigation.
add_filter( 'the_content', 'pjs_move_post_navigation', 1 );

if ( ! function_exists( 'pjs_embed_oembed_html' ) ) :
	/**
	 * Add responsive oembed class only for youtube and vimeo.
	 *
	 * @add_filter embed_oembed_html
	 * @class pjs_embed_oembed_html
	 * @param string $html displaying html Format.
	 * @param string $url url ombed like youtube, video.
	 * @param string $attr Attribute Iframe.
	 * @param int    $post_id Post ID.
	 * @link https://developer.wordpress.org/reference/hooks/embed_oembed_html/
	 */
	function pjs_embed_oembed_html( $html, $url, $attr, $post_id ) {
		$classes = array();
		/* Add these classes to all embeds. */
		$classes_all = array(
			'pjs-video-responsive',
		);

		/* Check for different providers and add appropriate classes. */
		if ( false !== strpos( $url, 'vimeo.com' ) ) {
			$classes[] = 'pjs-embed-responsive pjs-embed-responsive-16by9';
		}

		if ( false !== strpos( $url, 'youtube.com' ) ) {
			$classes[] = 'pjs-embed-responsive pjs-embed-responsive-16by9';
		}

		if ( false !== strpos( $url, 'youtu.be' ) ) {
			$classes[] = 'pjs-embed-responsive pjs-embed-responsive-16by9';
		}

		$classes = array_merge( $classes, $classes_all );

		return '<div class="' . esc_attr( implode( ' ', $classes ) ) . '">' . $html . '</div>';
	}
endif; // endif pjs_embed_oembed_html.
add_filter( 'embed_oembed_html', 'pjs_embed_oembed_html', 99, 4 );

if ( ! function_exists( 'lokerpro_prepend_attachment' ) ) :
	/**
	 * Callback for WordPress 'prepend_attachment' filter.
	 *
	 * Change the attachment page image size to 'large'
	 *
	 * @package WordPress
	 * @category Attachment
	 * @see wp-includes/post-template.php
	 *
	 * @param string $attachment_content the attachment html.
	 * @return string $attachment_content the attachment html
	 */
	function lokerpro_prepend_attachment( $attachment_content ) {
		$post = get_post();
		if ( wp_attachment_is( 'image', $post ) ) {
			// set the attachment image size to 'large'.
			$attachment_content = sprintf( '<p class="img-center">%s</p>', wp_get_attachment_link( 0, 'full', false ) );

			// return the attachment content.
			return $attachment_content;

		} else {
			// return the attachment content.
			return $attachment_content;
		}

	}
endif; // endif lokerpro_prepend_attachment.
add_filter( 'prepend_attachment', 'lokerpro_prepend_attachment' );

if ( ! function_exists( 'lokerpro_author_box' ) ) {

	/**
	 * Adding the author box to the end of your single post
	 *
	 * @param string $autbox HTML author box.
	 * @since 1.0.0
	 * @return void
	 */
	function lokerpro_author_box( $autbox = null ) {
		// Displaying only in single, archive and author page.
		if ( is_single() || is_author() || is_archive() ) {

			$opsiauthorbox = get_theme_mod( 'pjs_active-authorbox', 0 );

			if ( 0 === $opsiauthorbox ) {

				global $post;
				$author_id = $post->post_author;

				// hide the author box if no description is provided.
				if ( ! empty( get_the_author_meta( 'description' ) ) ) {

					$autbox .= '<div class="pjs-authorbox clearfix">';

						// author box gravatar.
						$autbox .= '<div class="pjs-ab-gravatar">';
						$autbox .= get_avatar( get_the_author_meta( 'user_email', $author_id ), '48' );
						$autbox .= '</div>';

						// author box name.
						$autbox .= '<div class="pjs-ab-content">';
						$autbox .= '<div class="pjs-ab-authorname">';

						$autbox .= '<span class="uname">';
						$autbox .= '<a href="' . get_author_posts_url( $author_id ) . '" title="' . get_the_author_meta( 'display_name', $author_id ) . '">' . get_the_author_meta( 'display_name', $author_id ) . '</a>';
						$autbox .= '</span>';

					if ( is_author() || is_archive() ) {
						// force show author website on author.php or archive.php.
						if ( ! empty( get_the_author_meta( 'user_url' ) ) ) {
							$autbox .= '<span class="pjs-ab-web">';
							$autbox .= ' <a href="' . get_the_author_meta( 'user_url', $author_id ) . '" title="' . get_the_author_meta( 'user_url', $author_id ) . '" target="_blank" rel="nofollow"><span class="icon_globe-2"></span></a>';
							$autbox .= '</span>';
						}
					}

					if ( is_single() ) {
						// author website on single.
						if ( ! empty( get_the_author_meta( 'user_url' ) ) ) {
							$autbox .= '<span class="pjs-ab-web">';
							$autbox .= ' <a href="' . get_the_author_meta( 'user_url', $author_id ) . '" title="' . get_the_author_meta( 'user_url', $author_id ) . '" target="_blank" rel="nofollow"><span class="icon_globe-2"></span></a>';
							$autbox .= '</span>';
						}
					}

							$autbox .= '</div>';

							// author box description.
							$autbox .= '<div class="pjs-ab-desc">';
							$autbox .= get_the_author_meta( 'description', $author_id );
							$autbox .= '</div>';

						$autbox .= '</div>'; // end pjs-ab-content.

					$autbox .= '</div>'; // end pjs-authorbox-wrap.
				}
			}
		}
		echo $autbox; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
}
add_action( 'lokerpro_author_box', 'lokerpro_author_box', 10 );

if ( ! function_exists( 'lokerpro_related_post' ) ) {
	/**
	 * Adding the related post to the end of your single post
	 *
	 * @since 1.0.0
	 * @return string
	 */
	function lokerpro_related_post() {
		global $post;
		$dpr_relpost = get_option( 'dpr_relpost' );

		$numberposts = get_theme_mod( 'pjs_relpost_number', '6' );
		$taxonomy    = get_theme_mod( 'pjs_relpost_taxonomy', 'pjs-category' );

		if ( 'pjs-tags' === $taxonomy ) {
			$tags = wp_get_post_tags( $post->ID );
			if ( $tags ) {
				$tag_ids = array();

				foreach ( $tags as $individual_tag ) {
					$tag_ids[] = $individual_tag->term_id;

					$args = array(
						'tag__in'             => $tag_ids,
						'post__not_in'        => array( $post->ID ),
						'posts_per_page'      => absint( $numberposts ),
						'ignore_sticky_posts' => 1,
					);
				}
			}
		} else {
			$categories = get_the_category( $post->ID );
			if ( $categories ) {
				$category_ids = array();
				foreach ( $categories as $individual_category ) {
					$category_ids[] = $individual_category->term_id;

					$args = array(
						'category__in'        => $category_ids,
						'post__not_in'        => array( $post->ID ),
						'posts_per_page'      => absint( $numberposts ),
						'ignore_sticky_posts' => 1,
					);
				}
			}
		}

		if ( ! isset( $args ) ) {
			$args = '';
		}

		$lokerpro_query = new WP_Query( $args );

		// Disable thumbnail options via customizer.
		$thumbnail = get_theme_mod( 'pjs_active-blogthumb', 0 );

		// Disable meta data options via customizer.
		$metadata = get_theme_mod( 'pjs_active-metaarchive', 0 );

		$content = '';
		if ( $lokerpro_query->have_posts() ) {

			$content .= '<div class="lokerpro-related-post">';
			$content .= '<h3 class="related-title">' . __( 'Related posts:', 'lokerpro' ) . '</h3>';
			while ( $lokerpro_query->have_posts() ) :
				$lokerpro_query->the_post();

				$featured_image_url = wp_get_attachment_url( get_post_thumbnail_id( $post->ID ) );

				$hasthumbnail = '';
				if ( ! empty( $featured_image_url ) ) {
					$hasthumbnail = ' has-post-thumbnail';
				}

				$content .= '<div class="pjs-box-content pjs-archivepage pjs-smallthumb' . $hasthumbnail . '">';
				$content .= '<div class="pjs-list-table">';
				$content .= '<div class="pjs-table-row">';
//
//				if ( ! empty( $featured_image_url ) ) :
//					$content .= '<div class="content-thumbnail pjs-table-cell">';
//					$content .= '<a href="' . get_permalink() . '" itemprop="url" title="' . the_title_attribute(
//						array(
//							'before' => __( 'Permalink to: ', 'lokerpro' ),
//							'after'  => '',
//							'echo'   => false,
//						)
//					) . '" rel="bookmark">';
	//				$content .= get_the_post_thumbnail( $post->ID, 'thumbnail' );
//			        $content .= get_the_post_thumbnail( $post->ID);
//					$content .= '</a>';
//					$content .= '</div>'; // End content-thumbnail pjs-table-cell.
//				endif;

				$content .= '<div class="pjs-table-cell">';
//				$content .= '<div class="header-title-related">';

				$content .= '<div class="post-title limit-title-related">';
				$content .= '<a href="' . get_permalink() . '" itemprop="url" title="' . the_title_attribute(
					array(
						'before' => __( 'Permalink to: ', 'lokerpro' ),
						'after'  => '',
						'echo'   => false,
					)
				) . '" rel="bookmark">' . get_the_title() . '</a>';
				$content .= '</div>'; // End content-thumbnail pjs-table-cell.

	

//				$content .= '</div>'; // End header-title.
				$content .= '</div>'; // End pjs-table-cell.

				$content .= '</div>';
				$content .= '</div>';
				$content .= '</div>';

			endwhile;
			wp_reset_postdata();
			$content .= '</div>';
		} // if have posts

		return $content;
	}
}

if ( ! function_exists( 'lokerpro_related_post_display' ) ) :
	/**
	 * Displaying Related Posts
	 *
	 * @param string $related String related posts.
	 * @since 1.0.0
	 */
	function lokerpro_related_post_display( $related = null ) {
		if ( is_single() && in_the_loop() ) {
			$relatedposts = get_theme_mod( 'pjs_active-relpost', 0 );
			if ( 0 === $relatedposts ) {
				$related = lokerpro_related_post();
			} else {
				$related = '';
			}
		}
		echo $related; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

	}
endif; // endif lokerpro_related_post_display.
add_action( 'lokerpro_related_post_display', 'lokerpro_related_post_display' );

if ( ! function_exists( 'lokerpro_share_default' ) ) :
	/**
	 * Insert social share from plugin
	 *
	 * @since 1.0.0
	 * @param string $output Output.
	 * @return string @output
	 */
	function lokerpro_share_default( $output = null ) {
		$socialshare = get_theme_mod( 'pjs_active-socialshare', 0 );

		if ( 0 === $socialshare ) {
			$filter_title = wp_strip_all_tags( rawurlencode( get_the_title() ) );
			$output  = '';
			$output .= '<a href="https://www.facebook.com/sharer/sharer.php?u=' . rawurlencode( esc_url( get_the_permalink() ) ) . '" class="lokerpro-sharebtn lokerpro-facebook wp-dark-mode-ignore" target="_blank" rel="nofollow" title="' . __( 'Share this', 'lokerpro' ) . '">';
			$output .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24"><g fill="none"><path d="M9.198 21.5h4v-8.01h3.604l.396-3.98h-4V7.5a1 1 0 0 1 1-1h3v-4h-3a5 5 0 0 0-5 5v2.01h-2l-.396 3.98h2.396v8.01z" fill="currentColor"/></g></svg>';
			$output .= '</a>';
			$output .= '<a href="https://twitter.com/share?url=' . rawurlencode( esc_url( get_the_permalink() ) ) . '&amp;text=' . rawurlencode( wp_strip_all_tags( get_the_title() ) ) . '" class="lokerpro-sharebtn lokerpro-twitter wp-dark-mode-ignore" target="_blank" rel="nofollow" title="' . __( 'Tweet this', 'lokerpro' ) . '">';
			$output .= '<svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M18.901 1.153h3.68l-8.04 9.19L24 22.846h-7.406l-5.8-7.584l-6.638 7.584H.474l8.6-9.83L0 1.154h7.594l5.243 6.932ZM17.61 20.644h2.039L6.486 3.24H4.298Z"></path></svg>';
			$output .= '</a>';
			$output .= '<a href="https://t.me/share/url?url=' . rawurlencode( esc_url( get_the_permalink() ) ) . '&amp;text=' . rawurlencode( wp_strip_all_tags( get_the_title() ) ) . '" class="lokerpro-sharebtn lokerpro-telegram wp-dark-mode-ignore" target="_blank" rel="nofollow" title="' . __( 'Telegram', 'lokerpro' ) . '">';
			$output .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 48 48"><path d="M41.42 7.309s3.885-1.515 3.56 2.164c-.107 1.515-1.078 6.818-1.834 12.553l-2.59 16.99s-.216 2.489-2.159 2.922c-1.942.432-4.856-1.515-5.396-1.948c-.432-.325-8.094-5.195-10.792-7.575c-.756-.65-1.62-1.948.108-3.463L33.648 18.13c1.295-1.298 2.59-4.328-2.806-.649l-15.11 10.28s-1.727 1.083-4.964.109l-7.016-2.165s-2.59-1.623 1.835-3.246c10.793-5.086 24.068-10.28 35.831-15.15z" fill="currentColor"/></svg>';
			$output .= '</a>';
			$output .= '<a href="https://api.whatsapp.com/send?text=' . rawurlencode( wp_strip_all_tags( get_the_title() ) ) . ' ' . rawurlencode( esc_url( get_permalink() ) ) . '" class="lokerpro-sharebtn lokerpro-whatsapp wp-dark-mode-ignore" target="_blank" rel="nofollow" title="' . __( 'WhatsApp', 'lokerpro' ) . '">';
			$output .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24"><path d="M12.04 2c-5.46 0-9.91 4.45-9.91 9.91c0 1.75.46 3.45 1.32 4.95L2.05 22l5.25-1.38c1.45.79 3.08 1.21 4.74 1.21c5.46 0 9.91-4.45 9.91-9.91c0-2.65-1.03-5.14-2.9-7.01A9.816 9.816 0 0 0 12.04 2m.01 1.67c2.2 0 4.26.86 5.82 2.42a8.225 8.225 0 0 1 2.41 5.83c0 4.54-3.7 8.23-8.24 8.23c-1.48 0-2.93-.39-4.19-1.15l-.3-.17l-3.12.82l.83-3.04l-.2-.32a8.188 8.188 0 0 1-1.26-4.38c.01-4.54 3.7-8.24 8.25-8.24M8.53 7.33c-.16 0-.43.06-.66.31c-.22.25-.87.86-.87 2.07c0 1.22.89 2.39 1 2.56c.14.17 1.76 2.67 4.25 3.73c.59.27 1.05.42 1.41.53c.59.19 1.13.16 1.56.1c.48-.07 1.46-.6 1.67-1.18c.21-.58.21-1.07.15-1.18c-.07-.1-.23-.16-.48-.27c-.25-.14-1.47-.74-1.69-.82c-.23-.08-.37-.12-.56.12c-.16.25-.64.81-.78.97c-.15.17-.29.19-.53.07c-.26-.13-1.06-.39-2-1.23c-.74-.66-1.23-1.47-1.38-1.72c-.12-.24-.01-.39.11-.5c.11-.11.27-.29.37-.44c.13-.14.17-.25.25-.41c.08-.17.04-.31-.02-.43c-.06-.11-.56-1.35-.77-1.84c-.2-.48-.4-.42-.56-.43c-.14 0-.3-.01-.47-.01z" fill="currentColor"/></svg>';
			$output .= '</a>';
			$output .= '<a href="mailto:?subject=' . rawurlencode( wp_strip_all_tags( get_the_title() ) ) . '&amp;body=' . rawurlencode( wp_strip_all_tags( get_the_title() ) ) . ' ' . rawurlencode( esc_url( get_permalink() ) ) . '" class="lokerpro-sharebtn lokerpro-email wp-dark-mode-ignore" target="_blank" rel="nofollow" title="' . __( 'Email This', 'lokerpro' ) . '">';
			$output .= '<svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 32 32"><path d="M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm-2.2 2L16 14.78L6.2 8zM4 24V8.91l11.43 7.91a1 1 0 0 0 1.14 0L28 8.91V24z" fill="currentColor"/></svg>';
			$output .= '</a>';

		}

		return $output;

	}
endif; // endif lokerpro_share_default.

if ( ! function_exists( 'lokerpro_add_share_the_content' ) ) :
	/**
	 * Insert content after box content single
	 *
	 * @since 1.0.0
	 * @link https://jetpack.com/support/related-posts/customize-related-posts/#delete
	 * @return void
	 */
	function lokerpro_add_share_the_content() {
		if ( is_single() && in_the_loop() ) {
			echo lokerpro_share_default(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		}
	}
endif; // endif lokerpro_add_share_the_content.
add_action( 'lokerpro_add_share_the_content', 'lokerpro_add_share_the_content', 30 );
