<?php
/**
 * Custom taxonomy for movie post
 *
 * Author: Pojoksoft - http://www.pojoksoft.com
 *
 * @since 1.0.0
 * @package Lokerpro Core
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'lokerpro_core_post_menu_label' ) ) {
	/**
	 * Change post menu label
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function lokerpro_core_post_menu_label() {
		global $menu;
		global $submenu;
		$menu[5][0]                 = __( 'Job Vacancy', 'lokerpro' );
		$submenu['edit.php'][5][0]  = __( 'All Job Vacancy', 'lokerpro' );
		$submenu['edit.php'][10][0] = __( 'Add Job Vacancy', 'lokerpro' );
		echo '';
	}
}
add_action( 'admin_menu', 'lokerpro_core_post_menu_label' );

if ( ! function_exists( 'lokerpro_core_post_object_label' ) ) {
	/**
	 * Change post object label
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function lokerpro_core_post_object_label() {
		global $wp_post_types;
		$labels                = &$wp_post_types['post']->labels;
		$labels->name          = __( 'Job Vacancy', 'lokerpro' );
		$labels->singular_name = __( 'Job Vacancy', 'lokerpro' );
		$labels->add_new       = __( 'Add Job Vacancy', 'lokerpro' );
		$labels->add_new_item  = __( 'Add New Job Vacancy', 'lokerpro' );
		$labels->edit_item     = __( 'Edit Job Vacancy', 'lokerpro' );
		$labels->new_item      = __( 'Job Vacancy', 'lokerpro' );
	}
}
add_action( 'init', 'lokerpro_core_post_object_label' );

if ( ! function_exists( 'lokerpro_core_admin_post_menu_icons_css' ) ) {
	/**
	 * Add css
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function lokerpro_core_admin_post_menu_icons_css() {
		?>
		<style>
			.dashicons-admin-post:before,
			.dashicons-format-standard:before{content:"\f219"}
		</style>
		<?php
	}
}
add_action( 'admin_head', 'lokerpro_core_admin_post_menu_icons_css' );
