<?php
/**
 * Custom query for movie post
 *
 * Author: Pojoksoft - http://www.pojoksoft.com
 *
 * @since 1.0.0
 * @package Idmuvi Core
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'lokerpro_custom_rewrite_rule' ) ) {
	/**
	 * Custom Rewrite Rule Download Page
	 */
	function lokerpro_custom_rewrite_rule() {
		add_rewrite_endpoint( 'apply', EP_PERMALINK );
	}
}
add_action( 'init', 'lokerpro_custom_rewrite_rule', 10, 0 );

if ( ! function_exists( 'lokerpro_filter_request' ) ) {
	/**
	 * Filter Request Download Page
	 *
	 * @link https://wordpress.stackexchange.com/questions/42279/custom-post-type-permalink-endpoint/42288
	 * @param String $vars Variable.
	 */
	function lokerpro_filter_request( $vars ) {
		if ( isset( $vars['apply'] ) && empty( $vars['apply'] ) ) {
			$vars['apply'] = true;
		} elseif ( isset( $vars['apply'] ) && ! empty( $vars['apply'] ) ) {
			$vars['apply'] = 'notempty';
		}
		return $vars;
	}
}
add_filter( 'request', 'lokerpro_filter_request' );

if ( ! function_exists( 'lokerpro_catch_vars' ) ) {
	/**
	 * Catch Variable
	 */
	function lokerpro_catch_vars() {
		global $wp_query;
		if ( is_singular( 'post' ) && ( 'notempty' === get_query_var( 'apply' ) ) ) {
			global $wp_query;
			$wp_query->set_404();
			status_header( 404 );
			get_template_part( 404 );
			exit();
		}
	}
}
add_action( 'template_redirect', 'lokerpro_catch_vars' );