<?php
/**
 * Banner features
 *
 * Author: Pojoksoft - http://www.pojoksoft.com
 *
 * @since 1.0.0
 * @package Lokerpro
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'lokerpro_top_banner_after_menu' ) ) {

	/**
	 * Adding banner at top via hook
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function lokerpro_top_banner_after_menu() {
		$banner    = get_theme_mod( 'pjs_adsaftermenu' );

		if ( isset( $banner ) && ! empty( $banner ) ) {
			echo '<div class="container">';
				echo '<div class="lokerpro-topbanner-aftermenu">';
				echo do_shortcode( $banner );
				echo '</div>';
			echo '</div>';
		}
	}
}
add_action( 'lokerpro_top_banner_after_menu', 'lokerpro_top_banner_after_menu', 10 );

if ( ! function_exists( 'lokerpro_banner_before_content' ) ) {

	/**
	 * Adding banner at before content via hook
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function lokerpro_banner_before_content() {
		$banner    = get_theme_mod( 'pjs_adsbeforecontent' );
		$position  = get_theme_mod( 'pjs_adsbeforecontentposition' );

		if ( isset( $banner ) && ! empty( $banner ) ) {
			if ( 'floatleft' === $position ) {
				$class = ' pull-left';
			} elseif ( 'floatright' === $position ) {
				$class = ' pull-right';
			} elseif ( 'center' === $position ) {
				$class = ' text-center';
			} else {
				$class = '';
			}
			echo '<div class="lokerpro-banner-beforecontent' . esc_html( $class ) . '">';
			echo do_shortcode( $banner );
			echo '</div>';
		}
	}
}

if ( ! function_exists( 'lokerpro_add_banner_before_content' ) ) :
	/**
	 * Insert content after box content single
	 *
	 * @since 1.0.0
	 * @param string $content Content.
	 * @return string $content
	 */
	function lokerpro_add_banner_before_content( $content ) {
		if ( is_singular( array( 'post', 'blogs' ) ) && in_the_loop() ) {
			$content = lokerpro_banner_before_content() . $content;
		}
		return $content;
	}
endif; // endif lokerpro_add_banner_before_content.
add_filter( 'the_content', 'lokerpro_add_banner_before_content', 30, 1 );

if ( ! function_exists( 'lokerpro_banner_after_content' ) ) {

	/**
	 * Adding banner at before content via hook
	 *
	 * @since 1.0.0
	 * @return string
	 */
	function lokerpro_banner_after_content() {
		$banner    = get_theme_mod( 'pjs_adsaftercontent' );
		$position  = get_theme_mod( 'pjs_adsaftercontentposition' );

		$ads = '';
		
		if ( isset( $banner ) && ! empty( $banner ) ) {
			if ( 'right' === $position ) {
				$class = ' lokerpro-center-right';
			} elseif ( 'center' === $position ) {
				$class = ' lokerpro-center-ads';
			} else {
				$class = '';
			}
			$ads .= '<div class="lokerpro-banner-aftercontent' . esc_html( $class ) . '">';
			$ads .= do_shortcode( $banner );
			$ads .= '</div>';
		}
		return $ads;
	}
}

if ( ! function_exists( 'lokerpro_add_banner_after_content' ) ) :
	/**
	 * Insert content after box content single
	 *
	 * @since 1.0.0
	 * @param string $content Content.
	 * @return string $content
	 */
	function lokerpro_add_banner_after_content( $content ) {
		if ( is_singular( array( 'post', 'blogs' ) ) && in_the_loop() ) {
			$content = $content . lokerpro_banner_after_content();
		}
		return $content;
	}
endif; // endif lokerpro_add_banner_after_content.
add_filter( 'the_content', 'lokerpro_add_banner_after_content', 1 );

if ( ! function_exists( 'lokerpro_helper_after_paragraph' ) ) :
	/**
	 * Helper add content after paragprah
	 *
	 * @param String $insertion Code.
	 * @param Number $paragraph_id ID Paraghrap.
	 * @param String $content Code.
	 * @since 1.0.0
	 * @link http://stackoverflow.com/questions/25888630/place-ads-in-between-text-only-paragraphs
	 * @return string
	 */
	function lokerpro_helper_after_paragraph( $insertion, $paragraph_id, $content ) {
		if ( is_singular( array( 'post', 'blogs' ) ) && in_the_loop() ) {

			$closing_p  = '</p>';
			$paragraphs = explode( $closing_p, wptexturize( $content ) );
			$count      = count( $paragraphs );

			foreach ( $paragraphs as $index => $paragraph ) {
				$word_count = count( explode( ' ', $paragraph ) );
				if ( trim( $paragraph ) && $paragraph_id == $index + 1 ) {
					$paragraphs[ $index ] .= $closing_p;
				}
				if ( $paragraph_id == $index + 1 && $count >= 4 ) {
					$paragraphs[ $index ] .= $insertion;
				}
			}
		}
		return implode( '', $paragraphs );
	}
endif; // endif lokerpro_helper_after_paragraph.

if ( ! function_exists( 'lokerpro_add_banner_inside_content' ) ) :
	/**
	 * Insert content inside content single
	 *
	 * @since 1.0.0
	 * @param string $content Content.
	 * @return string $content
	 */
	function lokerpro_add_banner_inside_content( $content ) {
		$banner    = get_theme_mod( 'pjs_adsinsidecontent' );
		$position  = get_theme_mod( 'pjs_adsinsidecontentposition', 'left' );
		$location  = get_theme_mod( 'pjs_adsinsidecontentlocation', '2' );

		if ( isset( $banner ) && ! empty( $banner ) ) {
			if ( 'right' === $position ) {
				$class = ' lokerpro-center-right';
			} elseif ( 'center' === $position ) {
				$class = ' lokerpro-center-ads';
			} else {
				$class = '';
			}



			    // Check if we're inside a single post
			    if (null == $location) {
			        $location = 2;
			    } else {
			        $location = $location;
			    }
			    if ( is_single() && $banner!="" ) {
			        // Find the third paragraph
			        $paragraphs = explode( '</p>', $content );
			        

			        if ( count( $paragraphs ) > 0 && count( $paragraphs ) > $location) {
			            $new_content = '';
			            // Insert the sidebar after the third paragraph
			            for ( $i = 0; $i < count( $paragraphs ); $i++ ) {
			                $new_content .= $paragraphs[$i] . '</p>';
			                if ( $i == ($location - 1) ) {
			                    $new_content .=  '<div class="parallxads' . esc_html( $class ) . '"><div class="parallxads-wrap"><div class="parallxads-box">'. do_shortcode( $banner ) .'</div></div></div>';
			                }
			            }
			            $content = $new_content;
			        }
			    }
		}
		return $content;
	}
endif; // endif lokerpro_add_banner_inside_content.
add_filter( 'the_content', 'lokerpro_add_banner_inside_content' );

if ( ! function_exists( 'lokerpro_banner_after_relpost' ) ) {
	/**
	 * Adding banner after related posts via hook
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function lokerpro_banner_after_relpost() {
		$banner    = get_theme_mod( 'pjs_adsafterrelpost' );

		$position = get_theme_mod( 'pjs_adsafterrelpostposition' );

		if ( isset( $banner ) && ! empty( $banner ) ) {
			if ( 'right' === $position ) {
				$class = ' text-right';
			} elseif ( 'center' === $position ) {
				$class = ' text-center';
			} else {
				$class = '';
			}
			echo '<div class="pjs-banner-afterrelpost clearfix' . esc_html( $class ) . '">';
				echo do_shortcode( $banner );
			echo '</div>';
		}
	}
}
add_action( 'lokerpro_banner_after_relpost', 'lokerpro_banner_after_relpost', 10 );

if ( ! function_exists( 'lokerpro_floating_banner_left' ) ) {

	/**
	 * Adding banner at top via hook
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function lokerpro_floating_banner_left() {
		$banner = get_theme_mod( 'pjs_adsfloatleft' );

		if ( isset( $banner ) && ! empty( $banner ) ) {
			echo '<div class="lokerpro-floatbanner lokerpro-floatbanner-left"><div class="inner-float-left">';
			echo '<button onclick="parentNode.remove()" title="' . esc_html__( 'close', 'lokerpro' ) . '">' . esc_html__( 'close', 'lokerpro' ) . '</button>';
			echo do_shortcode( $banner );
			echo '</div></div>';
		}
	}
}
add_action( 'lokerpro_floating_banner_left', 'lokerpro_floating_banner_left', 10 );

if ( ! function_exists( 'lokerpro_floating_banner_right' ) ) {

	/**
	 * Adding floating banner
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function lokerpro_floating_banner_right() {
		$banner = get_theme_mod( 'pjs_adsfloatright' );

		if ( isset( $banner ) && ! empty( $banner ) ) {
			echo '<div class="lokerpro-floatbanner lokerpro-floatbanner-right"><div class="inner-float-right">';
			echo '<button onclick="parentNode.remove()" title="' . esc_html__( 'close', 'lokerpro' ) . '">' . esc_html__( 'close', 'lokerpro' ) . '</button>';
			echo do_shortcode( $banner );
			echo '</div></div>';
		}
	}
}
add_action( 'lokerpro_floating_banner_right', 'lokerpro_floating_banner_right', 15 );

if ( ! function_exists( 'lokerpro_floating_banner_footer' ) ) {

	/**
	 * Adding floating banner
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function lokerpro_floating_banner_footer() {
		$banner = get_theme_mod( 'pjs_adsfloatbottom' );

		if ( isset( $banner ) && ! empty( $banner ) ) {
			echo '<div class="lokerpro-floatbanner lokerpro-floatbanner-footer">';
				echo '<div class="inner-floatbanner-bottom">';
				echo '<button onclick="parentNode.remove()" title="' . esc_html__( 'close', 'lokerpro' ) . '">' . esc_html__( 'close', 'lokerpro' ) . '</button>';
				echo do_shortcode( $banner );
				echo '</div>';
			echo '</div>';

		}
	}
}
add_action( 'lokerpro_floating_footer', 'lokerpro_floating_banner_footer', 20 );

if ( ! function_exists( 'lokerpro_banner_footer' ) ) {

	/**
	 * Adding banner at footer via hook
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function lokerpro_banner_footer() {
		$banner = get_theme_mod( 'pjs_adsfooter' );

		if ( isset( $banner ) && ! empty( $banner ) ) {
			echo '<div class="container">';
				echo '<div class="lokerpro-footerbanner">';
				echo do_shortcode( $banner );
				echo '</div>';
			echo '</div>';
		}
	}
}
add_action( 'lokerpro_banner_footer', 'lokerpro_banner_footer', 10 );

if ( ! function_exists( 'lokerpro_banner_between_posts' ) ) {

	/**
	 * Adding banner between posts in archive and index post
	 *
	 * @since 1.0.5
	 * @return void
	 */
	function lokerpro_banner_between_posts() {
		global $wp_query;

		$banner   = get_theme_mod( 'pjs_adsbetweenpost' );
		$position = get_theme_mod( 'pjs_adsbetweenpostposition', 'third' );

		// Check if we're at the right position and option not empty.
		if ( isset( $banner ) && ! empty( $banner ) ) {
			if ( 'first' === $position ) {
				$numb = 0;
			} elseif ( 'second' === $position ) {
				$numb = 1;
			} elseif ( 'third' === $position ) {
				$numb = 2;
			} elseif ( 'fourth' === $position ) {
				$numb = 3;
			} else {
				$numb = 2;
			}

			if ( $wp_query->current_post === intval( $numb ) ) {
				// Display the banner.
				echo '<div class="pjs-infeed-banner item-infinite">';
				echo '<div class="pjs-box-content">';
					echo do_shortcode( $banner );
				echo '</div>';
				echo '</div>';

			}
		}
	}
}
add_action( 'lokerpro_banner_between_posts', 'lokerpro_banner_between_posts', 20 );
