<?php

namespace GPLoker\Inc;

class Shortcode {

	private $show_data;
	
	public function __construct() {
		$this->show_data = get_option('posts_per_page');
		add_shortcode( 'gploker_search_form', [ $this, 'searchForm' ] );
		add_shortcode( 'gploker_job_categories', [ $this, 'jobCategories' ] );
		add_shortcode( 'gploker_all_categories', [ $this, 'allCategories' ] );
		add_shortcode( 'gploker_companies', [ $this, 'Companies' ] );
		add_shortcode( 'gploker_recent_jobs', [ $this, 'recentJobs' ] );
		add_shortcode( 'gploker_jobs_by_categories', [ $this, 'jobsByCategories' ] );
		add_shortcode( 'gploker_jobs_by_tags', [ $this, 'jobsByTags' ] );
		add_shortcode( 'gploker_jobs_by_locations', [ $this, 'jobsByLocations' ] );
		add_shortcode( 'gploker_blog_search', [ $this, 'blogSearchForm' ] );
		
		add_shortcode( 'gploker_featured_jobs', [ $this, 'featuredJobs' ] );
		
		add_shortcode( 'gploker_bookmark_jobs', [ $this, 'getJobsFromBookmark' ] );
//		add_shortcode( 'gploker_post_views', [ $this, 'getJobsFromBookmark' ] );

	}

	public function searchForm() {
		ob_start();
		GPLokerSearchForm();

		return ob_get_clean();
	}

	public function jobCategories($atts) {
		$parameter = shortcode_atts( array(
			'show' => $this->show_data,
		), $atts );
		
		$default_icon_url = '//placehold.co/300';

		ob_start();
		echo '<div class="gploker-categories category_slider owl-carousel">';
		$categories = GPLokerGetCategories($parameter['show']);
		if ( $categories ) {
			$_categories = '';
			foreach ($categories as $category) {
				$_categories .= '<div class="category-item">';
				$_categories .= sprintf('<a href="%s"></a>',  $category['link']);
				
				$icon_url = ! empty( $category['icon']['url'] ) ? $category['icon']['url'] : $default_icon_url;
				
				$_categories .= sprintf('<img src="%s"/>', $icon_url);
				
				$_categories .= sprintf('<h3>%s</h3>', $category['name']);
				$_categories .= sprintf('<span>(%d Lowongan)</span>', $category['count']);
				$_categories .= '</div>';
			}

			echo $_categories;
		}
		echo '</div>';

		return ob_get_clean();
	}

	public function allCategories($atts) {
		$parameter = shortcode_atts( array(
			'show' => $this->show_data,
		), $atts );

        $default_icon_url = '//placehold.co/300';
        
		ob_start();
		echo '<ul class="gploker-all-categories">';
		$categories = GPLokerGetCategories($parameter['show']);
		if ( $categories ) {
		    
			$_categories = '';
			
			foreach ($categories as $category) {
				$_categories .= '<li class="all_cat category-item">';
				$_categories .= sprintf('<a href="%s"></a>',  $category['link']);
				
				$icon_url = ! empty( $category['icon']['url'] ) ? $category['icon']['url'] : $default_icon_url;
				
				$_categories .= sprintf('<img src="%s"/>', $icon_url);
				
				$_categories .= sprintf('<h3>%s</h3>', $category['name']);
				$_categories .= sprintf('<span>(%d Lowongan)</span>', $category['count']);
				$_categories .= '</li>';
			}

			echo $_categories;
		}
		
		echo '</ul>';

		return ob_get_clean();
	}

	public function recentJobs( $atts ) {
		$parameter = shortcode_atts( array(
			'show' => $this->show_data,
			'show-sticky' => false,
		), $atts );

		ob_start();
		echo '<div class="gploker-recent-jobs">';
		GPLokerGetRecentJobs( $parameter['show'], $parameter['show-sticky'] );
		echo '</div>';

		return ob_get_clean();
	}

	public function jobsByCategories( $atts ) {
		$parameter = shortcode_atts( array(
			'slug'  => '',
			'show' => $this->show_data,
		), $atts );

		ob_start();
		echo '<div class="gploker-jobs-by-categories">';
		GPLokerJobsByCategories( $parameter['slug'], $parameter['show'] );
		echo '</div>';

		return ob_get_clean();
	}

	public function jobsByTags( $atts ) {
		$parameter = shortcode_atts( array(
			'slug'  => '',
			'show' => $this->show_data,
		), $atts );

		ob_start();
		echo '<div class="gploker-jobs-by-tags">';
		GPLokerJobsByTags( $parameter['slug'], $parameter['show'] );
		echo '</div>';

		return ob_get_clean();
	}

	public function jobsByLocations( $atts ) {
		$parameter = shortcode_atts( array(
			'slug'  => '',
			'show' => $this->show_data,
		), $atts );

		ob_start();
		echo '<div class="gploker-jobs-by-locations">';
		GPLokerJobsByLocations( $parameter['slug'], $parameter['show'] );
		echo '</div>';

		return ob_get_clean();
	}

	public function Companies($atts) {
		$parameter = shortcode_atts( array(
			'show' => $this->show_data,
		), $atts );
		ob_start();
		echo '<div class="gploker-company-lists">';
		GPLokerCompanies($parameter['show']);
		echo '</div>';

		return ob_get_clean();
	}

	public function getJobsFromBookmark() {
		ob_start();
		echo '<div class="gploker-job-by-bookmark">';
		GPLokerJobsByBookmark();
		echo '</div>';

		return ob_get_clean();
	}
	
	public function blogSearchForm() {
	    
	    return '<div class="gploker-blog-search">' . get_search_form(['echo' => false]) . '</div>';
	}
	
	public function featuredJobs( $atts ) {
	    $parameter = shortcode_atts( array(
			'show' => $this->show_data,
		), $atts );
		
		ob_start();
		echo '<div class="gploker-featured-jobs">';
		GPLokerFeaturedJobs($parameter['show']);
		echo '</div>';

		return ob_get_clean();
	}
}

new Shortcode();