<?php

namespace GPLoker\Inc;

use function add_action;
use const GPLOKER_INC;

class Loader {
	private static $instance;

	public function __construct() {
		add_action( 'wp_enqueue_scripts', [ $this, 'frontEndScripts' ] );
		add_action( 'wp_enqueue_scripts', [ $this, 'useFontAwesome' ] );

		add_action( 'after_setup_theme', [ $this, 'fileIncludes' ] );
		add_action( 'after_setup_theme', [ $this, 'disableGutenberg' ] );

        require_once GPLOKER_INC . '/Import/Import.php';
        Import::init();
	}

	public static function run() {
		if ( ! self::$instance instanceof self ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function fileIncludes() {

		if ( function_exists('generate_get_option') ) {
			require_once GPLOKER_INC . '/template-tags.php';
			require_once GPLOKER_INC . '/codestar-framework/codestar-framework.php';
			require_once GPLOKER_INC . '/class.base-post.php';
			require_once GPLOKER_INC . '/class.option.php';
			require_once GPLOKER_INC . '/class.hook.php';
			require_once GPLOKER_INC . '/class.company-menu.php';
			require_once GPLOKER_INC . '/class.company.php';
			require_once GPLOKER_INC . '/class.job-menu.php';
			require_once GPLOKER_INC . '/class.job.php';
			require_once GPLOKER_INC . '/class.advertisement.php';
			require_once GPLOKER_INC . '/class.bookmark.php';
			require_once GPLOKER_INC . '/class.shortcode.php';
			require_once GPLOKER_INC . '/class.auto-page-break.php';
			require_once GPLOKER_INC . '/class.updater.php';
		}
	}

	public function frontEndScripts() {
		//wp_enqueue_script('jquery');
	}

	public function useFontAwesome() {
		if ( Option::get( 'menu_icon', false ) ) {
			wp_enqueue_style( 'fa5', '//use.fontawesome.com/releases/v5.13.0/css/all.css', array(), '5.13.0', 'all' );
			wp_enqueue_style( 'fa5-v4-shims', '//use.fontawesome.com/releases/v5.13.0/css/v4-shims.css', array(), '5.13.0', 'all' );
		}
	}

	public function disableGutenberg() {
		if ( class_exists( 'GPLoker\Inc\Option' ) && Option::get( 'disable_gutenberg', false ) ) {
			add_filter( 'gutenberg_use_widgets_block_editor', '__return_false', 100 );
			add_filter( 'use_widgets_block_editor', '__return_false' );
			add_filter( 'use_block_editor_for_post_type', '__return_false' );
		}

	}
}