<?php
namespace GPLoker\Inc;

class Neon_Companies extends Base_Post_Type {
	public function __construct() {
		parent::__construct( [
			'id'            => 'companies',
			'rewrite'       => 'perusahaan',
			'title'         => 'Perusahaan',
			'supports'      => [ 'title', 'editor', 'thumbnail' ],
			'menu_position' => 20,
			'menu_icon'     => 'dashicons-building',
			'show_in_rest'  => false,
			'group'         => [
				[
					'id'                  => 'industri',
					'title'               => 'Industri',
					'show_in_editor_page' => true,
					'show_admin_column' => true,
				],
			]
		] );

		$this->metabox();
	}


	private function metabox() {
		if ( class_exists( 'CSF' ) ) {

			$prefix = '_companies';

			\CSF::createMetabox( $prefix, array(
				'title'     => 'Attribut Perusahaan',
				'post_type' => $this->post_type_id,
				'data_type' => 'unserialize',
				'context'   => 'advanced',
				'priority'  => 'high',
			) );

			\CSF::createSection( $prefix, array(
				'fields' => array(
					array(
						'id'    => 'short_description',
						'type'  => 'wp_editor',
						'title' => 'Short Description',
						'media_buttons' => false,
					),
					array(
						'id'    => 'phone',
						'type'  => 'text',
						'title' => 'Nomor Telepon',
					),
					array(
						'id'    => 'email',
						'type'  => 'text',
						'title' => 'Email',
					),
					array(
						'id'         => 'website',
						'type'       => 'text',
						'title'      => 'Website',
						'attributes' => [
							'placeholder' => 'https://'
						]
					),
				)
			) );
		}
	}
}

new Neon_Companies();