<?php
const GPLOKER_BASE_DIR = __DIR__;
const GPLOKER_INC = GPLOKER_BASE_DIR . '/inc';

require_once GPLOKER_BASE_DIR . '/inc/class.loader.php';

add_action( 'wp_enqueue_scripts', 'gplokerpro_parent_styles' );
function gplokerpro_parent_styles() {
    wp_enqueue_style( 'owl-style', get_stylesheet_directory_uri().'/css/owl.carousel.min.css' );
    wp_enqueue_style( 'owl-theme-style', get_stylesheet_directory_uri().'/css/owl.theme.default.min.css' );
    wp_enqueue_style( 'bootstrap-icon', 'https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css');
    
    wp_enqueue_script( 'jquerylibs', get_stylesheet_directory_uri().'/js/jquery-3.7.0.min.js' );
    wp_enqueue_script( 'owljs', get_stylesheet_directory_uri().'/js/owl.carousel.min.js' );
    wp_enqueue_script( 'customjs', get_stylesheet_directory_uri().'/js/custom.js' );
}
add_filter( 'generate_meta_viewport', 'tu_disable_mobile_zoom' );
function tu_disable_mobile_zoom() {
    return '    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">';
}


# all in one seo
add_filter('aioseo_opengraph_default_image', 'GPLokerOpenGraph');

# rank math seo
add_filter('rank_math/opengraph/facebook/image', 'GPLokerOpenGraph');
add_filter('rank_math/opengraph/twitter/image', 'GPLokerOpenGraph');

# yoast
add_filter('wpseo_opengraph_image', 'GPLokerOpenGraph' );

function GPLokerOpenGraph( $image_url ) {
    
    if ( is_singular('lowongan') ) {
        $jobs = GPLokerGetCurrentJob();
        $image_url =  $jobs->getCompanyLogo('full');
    }
    
    return $image_url;
}

add_action('wp_head', function() {
    
    if ( is_singular('lowongan') ) {
        
        $jobs = GPLokerGetCurrentJob();
        $image_url =  $jobs->getCompanyLogo('full');
        
        if ( did_filter('wpseo_opengraph_image') == 0 ) {
            echo sprintf('    <meta property="og:image" content="%s" />', $image_url) . PHP_EOL;
        } else {
            
        }
        
        if ( did_filter('wpseo_twitter_image') == 0 ) {
            echo sprintf('    <meta name="twitter:image" content="%s" />', $image_url) . PHP_EOL;
        }
    }
    
    
    
}, 1);


GPLoker\Inc\Loader::run();
